"use strict";
/**
 * This module only contains type definitions.
 *
 * This is the source of truth for API exposed by the shared library which is used to manage the native service which actually does the content filtering.
 *
 * This is not intended to be used directly outside the [[@wontok/node-addon-content-filtering]] module.
 *
 * @module
 * @private
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallbackNames = exports.CommandNames = void 0;
var CommandNames;
(function (CommandNames) {
    CommandNames["activateNativeService"] = "activateNativeService";
    CommandNames["setBlockedCategories"] = "setBlockedCategories";
    CommandNames["setWhitelistedDomains"] = "setWhitelistedDomains";
    CommandNames["setLicenseExpirationTimestamp"] = "setLicenseExpirationTimestamp";
    CommandNames["startFiltering"] = "startFiltering";
    CommandNames["stopFiltering"] = "stopFiltering";
    CommandNames["updateTo"] = "updateTo";
})(CommandNames = exports.CommandNames || (exports.CommandNames = {}));
var CallbackNames;
(function (CallbackNames) {
    CallbackNames["onStateChange"] = "onStateChange";
    CallbackNames["onBlockedContent"] = "onBlockedContent";
})(CallbackNames = exports.CallbackNames || (exports.CallbackNames = {}));
